<?php if(isset($breadcrumb) && is_array($breadcrumb) && count($breadcrumb) > 0 && url()->current() != url('/') && url()->current() != url('/login')): ?>
    <div class="overflow-hidden position-relative mb-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb bg-white rounded shadow-sm d-flex justify-content-right" dir="rtl" style="font-weight: 500; padding: 15px;">
                <?php $__currentLoopData = $breadcrumb; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        // Use 'icon' key if set, otherwise fallback to fa-folder-open or fa-home
                        $icon = isset($row['icon']) ? $row['icon'] : ($key == 0 ? 'fa-home' : 'fa-folder-open');
                        // If icon contains 'fa ', use as is, else prepend 'fas '
                        $iconClass = Str::startsWith($icon, 'fa ') ? $icon : 'fas ' . $icon;
                    ?>
                    <?php if($key == count($breadcrumb) - 1): ?>
                        <li class="breadcrumb-item active text-primary" aria-current="page">
                            <i class="<?php echo e($iconClass); ?>"></i> <?php echo e($row['title']); ?>

                        </li>
                    <?php else: ?>
                        <li class="breadcrumb-item">
                            <a href="<?php echo e($row['url']); ?>" class="text-secondary">
                                <i class="<?php echo e($iconClass); ?>"></i> <?php echo e($row['title']); ?>

                            </a>
                        </li>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ol>
        </nav>
    </div>
<?php endif; ?>
<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<?php if(session('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?php echo e(session('error')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<?php if($errors->any()): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <ul class="mb-0">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<?php /**PATH C:\laragon\www\marketing_all\back_end\resources\views/includes/crumb.blade.php ENDPATH**/ ?>