<div class="row">
    <?php
    $proj_count = \App\Models\Company::count();
    $cats_count = \App\Models\Category::count();
    $prods_count = \App\Models\Product::count();
    $ads_count = \App\Models\Ads::count();
    $ads_count = \App\Models\Ads::count();
    $ads = \App\Models\Ads::orderBy('id','desc')->take(6)->get();
    $visits = \App\Models\Details::where('type','visit')->where('date', Carbon\Carbon::today()->format('Y-m-d'))->sum('count');
    $clicks_count = \App\Models\Details::where('type','!=','visit')->where('date', Carbon\Carbon::today()->format('Y-m-d'))->sum('count');

    ?>
    <!-- بطاقة عدد المشاريع -->
    <div class="col-xl-2 col-md-4 col-sm-6">
        <div class="card mb-30 p-3 text-center">
            <h5 class="mb-1">عدد المشاريع</h5>
            <h2><?php echo e($proj_count); ?></h2>
            <p class="font-12 text-muted">إجمالي كل المشاريع</p>
        </div>
    </div>

    <!-- بطاقة عدد الفروع -->
    <div class="col-xl-2 col-md-4 col-sm-6">
        <div class="card mb-30 p-3 text-center">
            <h5 class="mb-1">عدد الفروع</h5>
            <h2><?php echo e($cats_count); ?></h2>
            <p class="font-12 text-muted">ضمن جميع المشاريع</p>
        </div>
    </div>

    <!-- بطاقة عدد المنتجات -->
    <div class="col-xl-2 col-md-4 col-sm-6">
        <div class="card mb-30 p-3 text-center">
            <h5 class="mb-1">عدد المنتجات</h5>
            <h2> <?php echo e($prods_count); ?></h2>
            <p class="font-12 text-muted">جميع المنتجات </p>
        </div>
    </div>

    <!-- بطاقة عدد الحملات -->
    <div class="col-xl-2 col-md-4 col-sm-6">
        <div class="card mb-30 p-3 text-center">
            <h5 class="mb-1">عدد الحملات</h5>
            <h2><?php echo e($ads_count); ?></h2>
            <p class="font-12 text-muted">نشطة ومؤرشفة</p>
        </div>
    </div>

    <!-- بطاقة الانطباعات (Impressions) -->
    <div class="col-xl-2 col-md-4 col-sm-6">
        <div class="card mb-30 p-3 text-center">
            <h5 class="mb-1">الزيارات</h5>
            <h2><?php echo e($visits); ?></h2>
            <p class="font-12 text-muted">اليوم</p>
        </div>
    </div>

    <!-- بطاقة النقرات (Clicks) -->
    <div class="col-xl-2 col-md-4 col-sm-6">
        <div class="card mb-30 p-3 text-center">
            <h5 class="mb-1">الضغطات</h5>
            <h2><?php echo e($clicks_count); ?></h2>
            <p class="font-12 text-muted">اليوم</p>
        </div>
    </div>
</div>

<!-- مخططات سريعة -->
<div class="row">
    <!-- مخطط تطور الانطباعات -->
    <div class="col-xl-6 col-lg-12">
        <div class="card mb-30">
            <div class="card-body">
                <h5> الزيارات</h5>
                <canvas id="impressions-chart" class="chart"></canvas>
            </div>
        </div>
    </div>

    <!-- مخطط تطور النقرات -->
    <div class="col-xl-6 col-lg-12">
        <div class="card mb-30">
            <div class="card-body">
                <h5> الضغطات</h5>
                <canvas id="clicks-chart" class="chart"></canvas>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const impressionsData = {
        labels: ['الأحد', 'الإثنين', 'الثلاثاء', 'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
        datasets: [{
            label: 'الزيارات',
            data: [200, 400, 350, 500, 700, 600, 800],
            backgroundColor: 'rgba(54, 162, 235, 0.2)',
            borderColor: 'rgba(54, 162, 235, 1)',
            borderWidth: 2,
            fill: true,
            tension: 0.4
        }]
    };

    const clicksData = {
        labels: ['الأحد', 'الإثنين', 'الثلاثاء', 'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
        datasets: [{
            label: 'الضغطات',
            data: [50, 80, 60, 120, 90, 100, 150],
            backgroundColor: 'rgba(255, 99, 132, 0.2)',
            borderColor: 'rgba(255, 99, 132, 1)',
            borderWidth: 2,
            fill: true,
            tension: 0.4
        }]
    };

    new Chart(document.getElementById('impressions-chart').getContext('2d'), {
        type: 'line',
        data: impressionsData,
        options: {
            responsive: true,
            plugins: { legend: { display: false } }
        }
    });

    new Chart(document.getElementById('clicks-chart').getContext('2d'), {
        type: 'line',
        data: clicksData,
        options: {
            responsive: true,
            plugins: { legend: { display: false } }
        }
    });
});
</script>


<div class="row">
    <div class="col-12">
        <div class="card mb-30">
            <div class="card-body">
                <div class="d-flex justify-content-between mb-3">
                    <h5>أحدث الحملات</h5>
                </div>

                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>م</th>
                                <th>المشروع</th>
                                <th>الفروع / المنتجات</th>
                                <th>الحملة</th>
                                <th>الزيارات</th>
                                <th>الضغطات</th>
                                <th>التكلفة</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $ads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td> <?php echo e($loop->iteration); ?></td>
                                <td>
                                    <a href="#"><?php echo e($ad->company->name); ?> </a>
                                </td>
                                <td>
                                    <?php
                                    $selectedProductIds = is_array($ad->cats_ids)
                                    ? $ad->cats_ids
                                    : json_decode($ad->cats_ids, true);

                                    $selectedProductIds = is_array($selectedProductIds) ?
                                    $selectedProductIds : [];

                                    $cats = \App\Models\Category::whereIn('id',
                                    $selectedProductIds)->get();
                                    ?>

                                    <?php $__currentLoopData = $cats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                       <a href="#"><?php echo e($cat->name); ?>, </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <br>
                                    <?php
                                    $selectedProductIds = is_array($ad->product_ids)
                                    ? $ad->product_ids
                                    : json_decode($ad->product_ids, true);

                                    $selectedProductIds = is_array($selectedProductIds) ?
                                    $selectedProductIds : [];

                                    $products = \App\Models\Product::whereIn('id',
                                    $selectedProductIds)->get();
                                    ?>

                                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                      <small><?php echo e($product->name); ?>, </small>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                                <td><?php echo e($ad->name); ?> </td>
                                <td><?php echo e($ad->details->where('type','visit')->count()); ?></td>
                                <td><?php echo e($ad->details->where('type','!=','visit')->count()); ?></td>
                                <td><?php echo e($ad->total_amount); ?></td>

                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>
</div>
<?php /**PATH C:\laragon\www\marketing_all\back_end\resources\views/index.blade.php ENDPATH**/ ?>