<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" />
<link rel="stylesheet" href="<?php echo e(asset('assets/css/custom.css')); ?>">
<style>
.theme-input-style {
    width: 100%;
    padding: 10px 12px;
    border: 1.5px solid #ccc !important;
    border-radius: 8px;
    font-size: 14px;
    box-sizing: border-box;
    transition: border-color 0.3s ease;
}

.theme-input-style:focus {
    border-color: #4a57f5;
    outline: none;
}
</style>
<div class="row">
    <div class="col-12">
        <div class="card mb-30 radius-20">
            <div class="card-body pt-30">
                <h6 class="font-15 "> احصائيات الحملة</h6>
                <div class="col-md-3" style="float: inline-end;">
                    <form method="GET" action="<?php echo e(route('ads_details.index')); ?>"
                        class="d-flex align-items-center justify-content-end mb-3">
                        <label for="dateSelect" class="me-2 mb-0 fw-bold" style="white-space: nowrap;">
                            <i class="fa fa-calendar-alt me-1"></i> اختر التاريخ:
                        </label>
                        &nbsp;&nbsp;
                        <select class="form-control select-date rounded-pill shadow-sm theme-input-style"
                            id="dateSelect" name="month"
                            style="min-width: 140px; margin-left: 10px; font-size: 14px; height: 48px;"
                            onchange="this.form.submit()">
                            <option selected disabled>اختر التاريخ</option>
                            <?php
                            use Carbon\Carbon;
                            $dates = [];
                            $now = Carbon::now();
                            $dates[] = $now->format('Y-m');
                            for ($i = 1; $i <= 24; $i++) { $dates[]=$now->copy()->subMonths($i)->format('Y-m');
                                }
                                ?>
                                <?php $__currentLoopData = $dates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($date); ?>" <?php echo e(request()->get('month') == $date ? 'selected' : ''); ?>>
                                    <?php echo e($date); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <input type="hidden" name="ads_id" value="<?php echo e(request()->get('ads_id')); ?>">
                    </form>
                </div>
                <br>
                <br>

                <div class="table-responsive">
                    <!-- Invoice List Table -->
                    <table class="text-nowrap bg-white dh-table">
                        <thead class="thead-light">
                            <tr>
                                <th>اليوم </th>
                                <th>سعر اليوم</th>
                                <th>عدد الزيارات </th>
                                <th>عدد ضغطات الاتصال </th>
                                <th>عدد ضغطات الواتساب </th>
                                <th>عدد ضغطات الانستجرام </th>
                                <th>عدد ضغطات جوجل ماب </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $totalPhoneCount =0 ; $totalvisitCount =0; $totalwhatsCount =0;$totalinstaCount=0; $totalmapCount=0;  
                            $month = request()->get('month') ?? now()->format('Y-m');
                            $startOfMonth = \Carbon\Carbon::createFromDate($month, 1);
                            $daysInMonth = $startOfMonth->daysInMonth;

                            $ads = \App\Models\Ads::where('id',request()->get('ads_id'))->first();
                            $startDate = \Carbon\Carbon::parse($ads->start_date)->format('Y-m-d');
                            $endDate = \Carbon\Carbon::parse($ads->end_date)->format('Y-m-d');
                            $period = \Carbon\CarbonPeriod::create($startDate, $endDate);
                            ?>
                            <?php if(!empty($period) && count($data) > 0): ?>
                            <?php $__currentLoopData = $period; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <?php
                           
                            $visitCount =
                            \App\Models\Details::where('ads_id',request()->get('ads_id'))->where('type','visit')->where('date',$date)->sum('count');
                            $whatsCount =
                            \App\Models\Details::where('ads_id',request()->get('ads_id'))->where('type','whatsapp')->where('date',
                            $date)->sum('count');
                            $instaCount =
                            \App\Models\Details::where('ads_id',request()->get('ads_id'))->where('type','instagram')->where('date',
                            $date)->sum('count');
                            $phoneCount =
                            \App\Models\Details::where('ads_id',request()->get('ads_id'))->where('type','phone')->where('date',
                            $date)->sum('count');
                            $mapCount =
                            \App\Models\Details::where('ads_id',request()->get('ads_id'))->where('type','google_Map')->where('date',
                            $date)->sum('count');
                            
                            $totalPhoneCount += $phoneCount;
                            $totalvisitCount += $visitCount;
                            $totalwhatsCount += $whatsCount;
                            $totalmapCount += $mapCount;
                            $totalinstaCount += $instaCount;
                            ?>

                            <tr>
                                <td> <?php echo e($date->format('Y-m-d')); ?></td>
                                <td><?php echo e(optional($ads)->amount_per_day ?? ''); ?></td>
                                <td>
                                    <a href="<?php echo e(route('details.visits',['ads_id' => request()->get('ads_id'),'date' => $date->format('Y-m-d') ])); ?>"
                                        class="text-primary">
                                        <?php echo e($visitCount); ?> </a>
                                </td>
                                <td><?php echo e($phoneCount); ?></td>
                                <td><?php echo e($whatsCount); ?></td>
                                <td><?php echo e($instaCount); ?></td>
                                <td><?php echo e($mapCount); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </tbody>
                        <tfoot>
                            
                            <tr style="border-top:1px solid">
                                <td>الاجمالى</td>
                                <td>-</td> 
                                <td><?php echo e($totalvisitCount); ?></td>
                                <td><?php echo e($totalPhoneCount); ?></td>
                                <td><?php echo e($totalwhatsCount); ?></td>
                                <td><?php echo e($totalinstaCount); ?></td>
                                <td><?php echo e($totalmapCount); ?></td>
                            </tr>
                        </tfoot>
                    </table>
                    <!-- End Invoice List Table -->
                </div>
            </div>
        </div>

    </div>
</div><?php /**PATH C:\laragon\www\marketing_electron\back_end\resources\views/ads/details.blade.php ENDPATH**/ ?>