<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" />
<link rel="stylesheet" href="<?php echo e(asset('assets/css/custom.css')); ?>">
<style>
.theme-input-style {
    width: 100%;
    padding: 10px 12px;
    border: 1.5px solid #ccc !important;
    border-radius: 8px;
    font-size: 14px;
    box-sizing: border-box;
    transition: border-color 0.3s ease;
}

.theme-input-style:focus {
    border-color: #4a57f5;
    outline: none;
}
</style>
<div class="row">
    <div class="col-12">
        <div class="card mb-30 radius-20">
            <div class="card-body pt-30">
                <h6 class="font-15 "> احصائيات الحملة</h6>
                <div class="col-md-3" style="float: inline-end;">
                    <form method="GET" action="<?php echo e(route('ads_details.index')); ?>"
                        class="d-flex align-items-center justify-content-end mb-3">
                        <label for="dateSelect" class="me-2 mb-0 fw-bold" style="white-space: nowrap;">
                            <i class="fa fa-calendar-alt me-1"></i> اختر التاريخ:
                        </label>
                        &nbsp;&nbsp;
                        <select class="form-control select-date rounded-pill shadow-sm theme-input-style"
                            id="dateSelect" name="month"
                            style="min-width: 140px; margin-left: 10px; font-size: 14px; height: 48px;"
                            onchange="this.form.submit()">
                            <option selected disabled>اختر التاريخ</option>
                            <?php
                            use Carbon\Carbon;
                            $dates = [];
                            $now = Carbon::now();
                            $dates[] = $now->format('Y-m');
                            for ($i = 1; $i <= 24; $i++) { $dates[]=$now->copy()->subMonths($i)->format('Y-m');
                                }
                                ?>
                                <?php $__currentLoopData = $dates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($date); ?>" <?php echo e(request()->get('month') == $date ? 'selected' : ''); ?>>
                                    <?php echo e($date); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <input type="hidden" name="ads_id" value="<?php echo e(request()->get('ads_id')); ?>">
                    </form>
                </div>
                <br>
                <br>

                <div class="table-responsive">
                    <!-- Invoice List Table -->
                    <table class="text-nowrap bg-white dh-table">
                        <thead class="thead-light">
                            <tr>
                                <th>اليوم </th>
                                <th>سعر اليوم</th>
                                <th>عدد الزيارات </th>
                                <th>عدد ضغطات الاتصال </th>
                                <th>عدد ضغطات الواتساب </th>
                                <th>عدد ضغطات الانستجرام </th>
                                <?php 
                                   $comp_id = \App\Models\Ads::where('id',request()->get('ads_id'))->first()->company_id;
                                   $theme = \App\Models\Company::with('setting')->where('id',$comp_id)->first()->setting->theme_id;
                                ?>
                                <?php if($theme == 2): ?>
                                <th>عدد ضغطات جوجل ماب </th>
                                <th>عدد ضغطات قائمة الطعام </th>
                                <?php endif; ?>
                            </tr>
                        </thead>
                        <tbody>
                            
                            <?php for($day = 1; $day <= now()->daysInMonth; $day++): ?>
                                <?php
                                $fullDate = now()->startOfMonth()->addDays($day - 1)->toDateString();
                                $dailyItems = $data[$fullDate] ?? collect();
                                $visitCount = \App\Models\Details::where('ads_id',request()->get('ads_id'))->where('type','visit')->where('date', $fullDate)->sum('count');
                                $whatsCount = \App\Models\Details::where('ads_id',request()->get('ads_id'))->where('type','whatsapp')->where('date', $fullDate)->sum('count');
                                $instaCount = \App\Models\Details::where('ads_id',request()->get('ads_id'))->where('type','instagram')->where('date', $fullDate)->sum('count');
                                $phoneCount = \App\Models\Details::where('ads_id',request()->get('ads_id'))->where('type','phone')->where('date', $fullDate)->sum('count');
                                $mapCount = \App\Models\Details::where('ads_id',request()->get('ads_id'))->where('type','google_Map')->where('date', $fullDate)->sum('count');
                                $menuCount = \App\Models\Details::where('ads_id',request()->get('ads_id'))->where('type','menu')->where('date', $fullDate)->sum('count');

                                ?>
                                <tr>
                                    <?php if($fullDate == $dailyItems->first()?->date ): ?>
                                    <td><?php echo e($fullDate); ?></td>
                                    <?php else: ?>
                                    <?php continue; ?>;
                                    <?php endif; ?>
                                    <td><?php echo e(optional($dailyItems->first()?->ads)->amount_per_day ?? ''); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('details.visits',['ads_id' => request()->get('ads_id'),'date' => $fullDate ])); ?>" class="text-primary">
                                            <?php echo e($visitCount); ?> </a>
                                    </td>
                                    <td><?php echo e($phoneCount); ?></td>
                                    <td><?php echo e($whatsCount); ?></td>
                                    <td><?php echo e($instaCount); ?></td>
                                    <?php if($theme == 2): ?>
                                        <td><?php echo e($mapCount); ?></td>
                                        <td><?php echo e($menuCount); ?></td>
                                    <?php endif; ?>
                                </tr>
                                <?php endfor; ?>
                        </tbody>
                    </table>
                    <!-- End Invoice List Table -->
                </div>
            </div>
        </div>

    </div>
</div><?php /**PATH C:\laragon\www\marketing_all\back_end\resources\views/ads/details.blade.php ENDPATH**/ ?>