<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" />
<link rel="stylesheet" href="<?php echo e(asset('assets/css/custom.css')); ?>">

<style>
table.dataTable thead th,
table.dataTable thead td,
table.dataTable tfoot th,
table.dataTable tfoot td {
    text-align: justify !important;
}
</style>
<div class="row">
    <div class="col-12">

        <div class="card mb-30 radius-20">
            <div class="card-body pt-30">
                <h4 class="font-20 ">الفروع</h4>
                <div class="add-new-contact ml-20">
                    <a href="#" class="bg-success-light text-success btn ui-sortable-handle" data-toggle="modal"
                        data-target="#projectAddModal" style="float: left;">
                        فرع جديد
                    </a>
                </div>
                <div id="projectAddModal" class="modal fade">
                    <div class="modal-dialog modal-dialog-centered modal-xl">
                        <div class="modal-content">
                            <!-- Modal Body -->
                            <div class="modal-body">
                                <form action="<?php echo e(route('cats.store')); ?>" method="POST" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <div class="contact-account-setting media-body d-flex justify-content-between align-items-center"
                                        style="background: #e3e4e6; border-radius: 12px; padding-top: 20px; padding-bottom: 15px; margin-bottom: 24px; box-shadow: 0 2px 8px rgba(0,0,0,0.04);">
                                        <h4 class="mb-0"
                                            style="font-weight: bold; letter-spacing: 1px; text-align: left;padding-right: 10px;">
                                            إضف جديد</h4>
                                        <button type="button" class="close ml-2" data-dismiss="modal" aria-label="Close"
                                            style="padding-left: 10px;font-size: 2rem; background: none; border: none;">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <?php
                                    $company = App\Models\Company::find(request()->get('id'));
                                    $name = $company ? $company->name : '';
                                    $theme_id = $company ? $company->setting->theme_id : '';

                                    ?>
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group mb-4">
                                                <label for="name" class="mb-2 black bold">اسم الفرع <span
                                                        class="text-danger">*</span></label>
                                                <input type="text" class="theme-input-style" id="name" name="name"
                                                    placeholder="أدخل اسم الفرع">
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group mb-4">
                                                <label for="name" class="mb-2 black bold">رقم واتساب </label>
                                                <input type="number" class="theme-input-style" id="whatsapp"
                                                    name="whatsapp" placeholder="أدخل رقم المراسلة ">
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group mb-4">
                                                <label for="name" class="mb-2 black bold"> رقم للتواصل </label>
                                                <input type="number" class="theme-input-style" name="phone"
                                                    placeholder="أدخل رقم التواصل ">
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group mb-4">
                                                <label for="name" class="mb-2 black bold"> رابط إنستجرام </label>
                                                <input type="text" class="theme-input-style" name="instagram"
                                                    placeholder="أدخل رابط إنستجرام ">
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group mb-4">
                                                <label for="name" class="mb-2 black bold">رابط جوجل ماب </label>
                                                <input type="text" class="theme-input-style" name="google_Map"
                                                    placeholder="أدخل رابط جوجل ماب ">
                                            </div>
                                        </div>
                                        
                                        <div class="col-lg-6">
                                            <div class="form-group mb-4">
                                                <label for="name" class="mb-2 black bold">رابط جوجل ماب 2</label>
                                                <input type="text" class="theme-input-style" name="google_Map_2"
                                                    placeholder="أدخل رابط جوجل ماب ">
                                            </div>
                                        </div>

                                        <?php if($theme_id == 2): ?>
                                        <div class="col-lg-6">
                                            <div class="form-group mb-4">
                                                <label for="vendor_logo" class="mb-2 black bold">
                                                    قائمة الطعام (PDF)</label>
                                                <input type="file" class="theme-input-style" name="menu"
                                                    accept="application/pdf">
                                            </div>
                                        </div>
                                        <?php endif; ?>

                                        <div class="col-lg-12">
                                            <div class="form-group mb-4">
                                                <label for="description" class="mb-2 black bold">الوصف</label>
                                                <textarea class="theme-input-style" id="description" name="description"
                                                    rows="3" placeholder="وصف "></textarea>
                                            </div>
                                        </div>
                                        <input type="hidden" name="company_id" value="<?php echo e(request()->get('id')); ?>">
                                    </div>
                                    <div class="d-flex justify-content-center pt-3" style="padding-bottom: 10px;">
                                        <button type="submit" class="btn btn-primary ml-3">حفظ</button>
                                        <button type="reset" class="btn btn-secondary"
                                            data-dismiss="modal">إلغاء</button>
                                    </div>
                                </form>
                            </div>
                            <!-- End Modal Body -->
                        </div>
                    </div>
                </div>
                <div class="table-responsive">
                    <!-- Invoice List Table -->
                    <table class="text-nowrap bg-white dh-table">
                        <thead class="thead-light">
                            <tr>

                                <th>م</th>
                                <th>اسم الفرع</th>
                                <th>رقم الاتصال </th>
                                <th>رقم الواتساب </th>
                                <th>الوصف</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $one): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e(is_object($one) ? $one->name : ''); ?></td>
                                <td><?php echo e(is_object($one) ? $one->socialMedia->where('type','phone')->first()?->link : ''); ?>

                                </td>
                                <td><?php echo e(is_object($one) ? $one->socialMedia->where('type','whatsapp')->first()?->link : ''); ?>

                                </td>
                                <td> <?php echo e(is_object($one) ? $one->description : ''); ?> </td>
                                <td>
                                    <a class="btn btn-sm bg-info-light text-info mr-10" data-toggle="modal"
                                        data-target="#projectEditModal_<?php echo e($one->id); ?>">تعديل</a>
                                    <form action="<?php echo e(route('cats.destroy', $one->id)); ?>" method="POST"
                                        style="display:inline;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <input type="hidden" name="company_id" value="<?php echo e(request()->get('id')); ?>">
                                        <button type="submit" class="btn btn-sm bg-danger-light text-danger mr-10"
                                            onclick="return confirm('هل أنت متأكد من الحذف ');">حذف</button>
                                    </form>
                                </td>
                            </tr>
                            <div id="projectEditModal_<?php echo e($one->id); ?>" class="modal fade">
                                <div class="modal-dialog modal-dialog-centered modal-xl">
                                    <div class="modal-content">
                                        <!-- Modal Body -->
                                        <div class="modal-body">
                                            <form action="<?php echo e(route('cats.update',$one->id)); ?>" method="POST"
                                                enctype="multipart/form-data">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>
                                                <div class="contact-account-setting media-body d-flex justify-content-between align-items-center"
                                                    style="background: #e3e4e6; border-radius: 12px; padding-top: 20px; padding-bottom: 15px; margin-bottom: 24px; box-shadow: 0 2px 8px rgba(0,0,0,0.04);">
                                                    <h4 class="mb-0"
                                                        style="font-weight: bold; letter-spacing: 1px; text-align: left;padding-right: 10px;">
                                                        تعديل </h4>
                                                    <button type="button" class="close ml-2" data-dismiss="modal"
                                                        aria-label="Close"
                                                        style="padding-left: 10px;font-size: 2rem; background: none; border: none;">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="row">
                                                    <div class="col-lg-6">
                                                        <div class="form-group mb-4">
                                                            <label for="edit_name_<?php echo e($one->id); ?>"
                                                                class="mb-2 black bold">اسم الفرع <span
                                                                    class="text-danger">*</span></label>
                                                            <input type="text" class="theme-input-style" name="name"
                                                                value="<?php echo e($one->name); ?>">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <div class="form-group mb-4">
                                                            <label for="edit_name_<?php echo e($one->id); ?>"
                                                                class="mb-2 black bold">رقم واتساب </label>
                                                            <input type="number" class="theme-input-style"
                                                                name="whatsapp"
                                                                value="<?php echo e($one->socialMedia->where('type','whatsapp')->first()?->link); ?>">
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-6">
                                                        <div class="form-group mb-4">
                                                            <label for="edit_name_<?php echo e($one->id); ?>" class="mb-2 black bold">
                                                                رقم التواصل</label>
                                                            <input type="text" class="theme-input-style" name="phone"
                                                                value="<?php echo e($one->socialMedia->where('type','phone')->first()?->link); ?>">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <div class="form-group mb-4">
                                                            <label for="edit_name_<?php echo e($one->id); ?>" class="mb-2 black bold">
                                                                رابط إنستجرام </label>
                                                            <input type="text" class="theme-input-style"
                                                                name="instagram"
                                                                value="<?php echo e($one->socialMedia->where('type','instagram')->first()?->link); ?>">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <div class="form-group mb-4">
                                                            <label for="edit_name_<?php echo e($one->id); ?>" class="mb-2 black bold">
                                                                رابط جوجل ماب </label>
                                                            <input type="text" class="theme-input-style"
                                                                name="google_Map"
                                                                value="<?php echo e($one->socialMedia->where('type','google_Map')->first()?->link); ?>">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <div class="form-group mb-4">
                                                            <label for="edit_name_<?php echo e($one->id); ?>" class="mb-2 black bold">
                                                               رابط جوجل ماب 2 </label>
                                                            <input type="text" class="theme-input-style"
                                                                name="google_Map_2"
                                                                value="<?php echo e($one->socialMedia->where('type','google_Map_2')->first()?->link); ?>">
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-12">
                                                        <div class="form-group mb-4">
                                                            <label for="edit_description_<?php echo e($one->id); ?>"
                                                                class="mb-2 black bold">الوصف</label>
                                                            <textarea class="theme-input-style"
                                                                id="edit_description_<?php echo e($one->id); ?>" name="description"
                                                                rows="3"
                                                                placeholder="وصف "><?php echo e($one->description); ?></textarea>
                                                        </div>
                                                    </div>
                                                    <input type="hidden" name="company_id"
                                                        value="<?php echo e(request()->get('id')); ?>">
                                                </div>
                                                <div class="d-flex justify-content-center pt-3"
                                                    style="padding-bottom: 10px;">
                                                    <button type="submit" class="btn btn-primary ml-3">تعديل</button>
                                                    <button type="reset" class="btn btn-secondary"
                                                        data-dismiss="modal">إلغاء</button>
                                                </div>
                                            </form>
                                        </div>
                                        <!-- End Modal Body -->
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <!-- End Invoice List Table -->
                </div>
            </div>
        </div>

    </div>
</div><?php /**PATH /home/elect123/public_html/dashboard/resources/views/cats/index.blade.php ENDPATH**/ ?>