<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" />
<link rel="stylesheet" href="{{ asset('assets/css/custom.css') }}">
<style>
.theme-input-style {
    width: 100%;
    padding: 10px 12px;
    border: 1.5px solid #ccc !important;
    border-radius: 8px;
    font-size: 14px;
    box-sizing: border-box;
    transition: border-color 0.3s ease;
}

.theme-input-style:focus {
    border-color: #4a57f5;
    outline: none;
}
</style>
<style>
table.dataTable thead th,
table.dataTable thead td,
table.dataTable tfoot th,
table.dataTable tfoot td {
    text-align: justify !important;
}
</style>
<div class="row">
    <div class="col-12">
        <div class="card mb-30 radius-20">
            <div class="card-body pt-30">
                <h6 class="font-15 "> الحملات الاعلانية</h6>
                <div class="row mb-3 " style="margin-top: 20px;">
                    @if(!request()->has('comp_id'))
                    <div class="col-md-4">
                        <form method="GET" action="{{ route('all_ads' ) }}">
                            <select class="form-control theme-input-style" name="comp_id"
                                style="min-width: 140px; margin-left: 10px; font-size: 14px; height: 48px;"
                                id="company_id_filter">
                                <option value=""> كل المشاريع</option>
                                @php
                                $companies = App\Models\Company::all();
                                @endphp
                                @foreach ($companies as $comp)
                                <option value="{{ $comp->id }}"
                                    {{ request()->get('comp_id') == $comp->id ? 'selected' : '' }}>
                                    {{ $comp->name }}
                                </option>
                                @endforeach
                            </select>
                        </form>
                    </div>
                    @endif
                    <!-- Add your content for col-md-3 here -->
                    <div class="col-md-4"></div>
                    <div class="col-md-4" style="display: block; float: left; text-align: end;">
                        <div class="add-new-contact ml-20" style="float: left;">
                            <button class="btn btn-success dropdown-toggle" type="button" id="actionsDropdown"
                                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"
                                style="background-color: #707072c4; border-color: #28a745; color: #fff;">
                                خيارات
                            </button>
                            <div class="dropdown-menu" aria-labelledby="actionsDropdown">
                                <a class="dropdown-item" href="{{ route('excel.files') }}">
                                    <i class="fas fa-file-excel text-primary"></i> ملفات الاكسيل
                                </a>
                                <a class="dropdown-item" data-toggle="modal" data-target="#projectAddModal">
                                    <i class="fas fa-plus text-success"></i> حملة جديدة
                                </a>
                                <a class="dropdown-item" href="{{ route('excel.export',['id' => 'all']) }}">
                                    <i class="fas fa-file-export text-info"></i> تصدير الكل
                                </a>
                            </div>
                        </div>
                    </div>
                    <br /><br />



                </div>
                <div class="row">
                    <div class="col-md-4">

                    </div>
                    <div class="col-md-3"></div>
                    <div class="col-md-3"></div>

                    <div id="projectAddModal" class="modal fade">
                        <div class="modal-dialog modal-dialog-centered modal-xl">
                            <div class="modal-content">
                                <!-- Modal Body -->
                                <div class="modal-body">
                                    <form action="{{ route('ads_.store')}}" method="POST" enctype="multipart/form-data">
                                        @csrf
                                        <div class="contact-account-setting media-body d-flex justify-content-between align-items-center"
                                            style="background: #e3e4e6; border-radius: 12px; padding-top: 20px; padding-bottom: 15px; margin-bottom: 24px; box-shadow: 0 2px 8px rgba(0,0,0,0.04);">
                                            <h4 class="mb-0"
                                                style="font-weight: bold; letter-spacing: 1px; text-align: left;padding-right: 10px;">
                                                إضف جديد</h4>
                                            <button type="button" class="close ml-2" data-dismiss="modal"
                                                aria-label="Close"
                                                style="padding-left: 10px;font-size: 2rem; background: none; border: none;">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-6">
                                                <div class="form-group mb-4">
                                                    <label for="name" class="mb-2 black bold">اسم الحملة <span
                                                            class="text-danger">*</span></label>
                                                    <input type="text" class="theme-input-style" id="name" name="name"
                                                        placeholder="أدخل اسم الحملة">
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group mb-4">
                                                    <label for="company_id" class="mb-2 black bold">المشروع <span
                                                            class="text-danger">*</span></label>
                                                    <select class="theme-input-style" id="company_id" name="company_id"
                                                        style="height: 50px; font-size: 1.1rem;" >
                                                        @php
                                                        $url = url('/');
                                                        $companies = App\Models\Company::all();
                                                        @endphp
                                                        @foreach ($companies as $comp)
                                                        <option value="{{ $comp->id }}" selected>{{ $comp->name }}
                                                        </option>
                                                        @endforeach

                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group mb-4">
                                                    <label for="start_date" class="mb-2 black bold">تاريخ البدء <span
                                                            class="text-danger">*</span></label>
                                                    <input type="date" class="theme-input-style" id="start_date"
                                                        name="start_date">
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group mb-4">
                                                    <label for="end_date" class="mb-2 black bold">تاريخ النهاية <span
                                                            class="text-danger">*</span></label>
                                                    <input type="date" class="theme-input-style" id="end_date"
                                                        name="end_date">
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group mb-4">
                                                    <label for="amount_per_day" class="mb-2 black bold">قيمة الاعلان
                                                        لليوم <span class="text-danger">*</span></label>
                                                    <input type="number" class="theme-input-style" id="amount_per_day"
                                                        name="amount_per_day">
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group mb-4">
                                                    <label for="number_days" class="mb-2 black bold">عدد الايام</label>
                                                    <input type="text" class="theme-input-style" id="number_days"
                                                        name="number_days">
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group mb-4">
                                                    <label for="total_amount" class="mb-2 black bold">اجمالى
                                                        القيمة</label>
                                                    <input type="number" class="theme-input-style" id="total_amount"
                                                        name="total_amount">
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group mb-4">
                                                    <label for="number_days" class="mb-2 black bold">هاتف الحملة </label>
                                                    <input type="number" class="theme-input-style" 
                                                        name="phone">
                                                </div>
                                            </div>
                                            
                                            <div class="col-lg-6" id="branches">
                                                <div class="form-group mb-4">
                                                    <label for="cats_ids" class="mb-2 black bold">الفروع</label>
                                                    <select class="theme-input-style" id="cats_ids" name="cats_ids[]"
                                                        multiple style="min-height: 120px; height: 160px;">
                                                        @php
                                                            $cats = App\Models\Category::all();
                                                        @endphp
                                                        <option value="all">الكل </option>
                                                        @foreach ($cats as $comp)
                                                        <option value="{{ $comp->id }}" >{{ $comp->name }} </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-6" id="products" style="display:none">
                                                <div class="form-group mb-4">
                                                    <label for="product_ids" class="mb-2 black bold">المنتجات</label>
                                                    <select class="theme-input-style" id="product_ids"
                                                        name="product_ids[]" multiple
                                                        style="min-height: 120px; height: 160px;"></select>
                                                </div>
                                            </div>
                                           
                                            <div class="col-lg-12">
                                                <div class="form-group mb-4">
                                                    <label for="ad_image" class="mb-2 black bold">  رفع صورة او فيديو او PDF</label>
                                                    <input type="file" class="theme-input-style" id="ad_image"
                                                        name="image" accept="image/*,video/*,application/pdf">
                                                </div>
                                            </div>
                                            <div class="col-lg-12">
                                                <div class="form-group mb-4">
                                                    <label for="note" class="mb-2 black bold">ملاحظة</label>
                                                    <textarea class="theme-input-style" id="note" name="note"
                                                        rows="3"></textarea>
                                                </div>
                                            </div>


                                        </div>

                                        <div class="d-flex justify-content-center pt-3"
                                            style="    padding-bottom: 10px;">
                                            <button type="submit" class="btn btn-primary ml-3">حفظ</button>
                                            <button type="reset" class="btn btn-secondary"
                                                data-dismiss="modal">إلغاء</button>
                                        </div>
                                    </form>
                                </div>
                                <!-- End Modal Body -->
                            </div>
                        </div>
                    </div>
                </div>
                <br /><br />
                <div class="table-responsive">
                    <!-- Invoice List Table -->
                    <table class="text-nowrap bg-white dh-table" id="all_ads-table">
                        <thead>
                            <tr>
                                <th>م</th>
                                <th>اسم الحملة</th>
                                <th>اسم المشروع</th>
                                <th>صورة</th>
                                <th>الفروع </th>
                                <th>اللينك </th>
                                                                    <th>QR كود</th>

                                <th>احصائيات الاعلان </th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>

                    </table>
                    <!-- End Invoice List Table -->
                </div>
            </div>
        </div>

    </div>
</div>

<script type="text/javascript">
$(document).ready(function() {

    var table = $('#all_ads-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: "{{ route('allAds.data') }}",
            data: function(d) {
                d.comp_id = $('select[name="comp_id"]').val();
            }
        },
        columns: [{
                data: 'DT_RowIndex', // This field comes from addIndexColumn
                name: 'DT_RowIndex',
                orderable: false, // Optional: Prevent sorting
                searchable: false // Optional: Prevent searching
            },
            {
                data: 'name',
                name: 'name',
                searchable: true
            },
            {
                data: 'comp_name',
                name: 'comp_name'
            },
            {
                data: 'img',
                name: 'img'
            },
            {
                data: 'cat',
                name: 'cat'
            },

            {
                data: 'link',
                name: 'link'
            },
             {
                data: 'qr_code',
                name: 'qr_code',
                orderable: false,
                searchable: false
            },
            {
                data: 'statistics',
                name: 'statistics'
            },
            {
                data: 'actions',
                name: 'actions'
            }
        ],
        language: {
            url: "{{ asset('assets/js/datatables/ar.json') }}", // Arabic translations
        }
    });

    // Redraw table when company filter changes
    $('#company_id_filter').on('change', function() {
        table.ajax.reload();
    });
});
</script>
<script>
function checkData(comp_id) {
    $.ajax({
        type: 'get',
        dataType: "json",
        url: "{{ route('checkData', ':id') }}".replace(':id', comp_id),

        success: function(res) {
            const hasCats = Array.isArray(res.cats) && res.cats.length > 0;
            const hasProds = Array.isArray(res.prods) && res.prods.length > 0;

            if (hasCats) {
                console.log('cats');
                const selectCats = $('#cats_ids');
                $('#branches').show();
                selectCats.empty().append('<option value="all">الكل</option>');
                $.each(res.cats, function(index, cat) {
                    selectCats.append('<option value="' + cat.id + '">' + cat.name + '</option>');
                });
            } else {
                $('#branches').hide();
            }

            if (hasProds) {
                console.log('prods');
                const selectProds = $('#product_ids');
                $('#products').show();
                selectProds.empty().append('<option value="all">الكل</option>');
                $.each(res.prods, function(index, prod) {
                    selectProds.append('<option value="' + prod.id + '">' + prod.name +
                    '</option>');
                });
            } else {
                $('#products').hide();
            }


        },
        error: function(xhr, status, error) {
            console.error('AJAX Error:', status, error);
        }
    });
}

function editData(comp_id) {
    if (!comp_id) {
        $('#branches_2').hide();
        $('#products_2').hide();
        return;
    }

    $.ajax({
        type: 'get',
        dataType: "json",
        url: "{{ route('checkData', ':id') }}".replace(':id', comp_id),

        success: function(res) {
            console.log(res);
            if (res.cats && Array.isArray(res.cats) && res.cats.length > 0) {
                console.log('incats');
                let select = $('#cats_ids_2');

                select.empty();
                select.append('<option value="all">الكل</option>');
                $.each(res.cats, function(index, cat) {
                    select.append('<option value="' + cat.id + '"' + (cat.isSelected ? ' selected' :
                        '') + '>' + cat.name + '</option>');
                });
                $('#branches_2').show();
            }
            if (res.prods && Array.isArray(res.prods) && res.prods.length > 0) {
                console.log('inprod');

                let select = $('#product_ids_2');

                select.empty();
                select.append('<option value="all">الكل</option>');
                $.each(res.prods, function(index, prod) {
                    select.append('<option value="' + prod.id + '">' + prod.name + '</option>');
                });
                $('#products_2').show();
            } else {
                console.log('else case');
                $('#products_2').hide();
                $('#branches_2').hide();
            }
        },
        error: function(res) {

        }
    });
}
</script>

<script>
const startInput = document.getElementById('start_date');
const endInput = document.getElementById('end_date');
const output = document.getElementById('number_days');
const total_amount = document.getElementById('total_amount');
const amount_per_day = document.getElementById('amount_per_day');

function calculateDateDiff() {
    const start = new Date(startInput.value);
    const end = new Date(endInput.value);
    const perDayAmount = parseFloat(amount_per_day.value);

    if (!isNaN(start) && !isNaN(end)) {
        const diffTime = end - start;
        const diffDays = Math.floor(diffTime / (1000 * 60 * 60 * 24)) + 1;
        output.value = diffDays;
        total_amount.value = (diffDays * perDayAmount);
        // amountPerDay.value = parseFloat(amountPerDay.value).toFixed(3);
        console.log(total_amount.value);
    } else {
        output.value = '';
    }
}

startInput.addEventListener('change', calculateDateDiff);
endInput.addEventListener('change', calculateDateDiff);
amount_per_day.addEventListener('change', calculateDateDiff);
</script>