<?php

namespace App\Repositories;

use App\Interfaces\AdsInterface;
use App\Models\Ads;
use App\Models\Details;
use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Category;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Auth;

class AdsRepository implements AdsInterface
{
    public function index(Request $request)
    {
        
      return Ads::with('company', 'company.domains')
            ->where('company_id', $request->comp_id)
            //  ->when($request->filled('cat_id'), function ($query) use ($request) {

            //         $cats = is_array($request->cat_id) ? $request->cat_id : [$request->cat_id];
            //         $query->where(function ($q) use ($request, $cats) {
            //             // Include ads where 'cats_ids' contains 'all'
            //             $q->whereJsonContains('cats_ids', 'all');
                       
            //             // Include ads where 'cats_ids' contains any of the selected categories
            //             foreach ($cats as $catId) {
            //                 $q->whereJsonContains('cats_ids',  $request->cat_id);
            //             }     
            //             //  dd($q->get());                   
            //         });

            //     })
            ->get();
                    
    }
  public function getData()
{
    $query = Ads::with('company.setting', 'category','company.domains')->orderBy('id','desc');

    if (request()->filled('comp_id')) {
        $query->where('company_id', request()->get('comp_id'));
    }
//     if (request()->filled('cat_id')) {
//     $catId = request()->get('cat_id');
//     $compId = request()->get('comp_id');

//     $query = \App\Models\Ads::where('company_id', $compId)
//         ->where(function ($q) use ($catId) {
//             $q->orWhereJsonContains('cats_ids', 'all')
//               ->orWhereJsonContains('cats_ids', (int) $catId);
//         });

//     $ads = $query->get();
//     dd($ads);
// }


    return DataTables::eloquent($query)
        ->addIndexColumn()
        ->addColumn('comp_name', function ($ad) {
            return $ad->company ? ($ad->company->name ?? '') : '';
        })
        ->addColumn('cat', function ($ad) {
            
             if ($ad->company && $ad->company->has_branch == 1) {
                $selectedCatsIds = is_array($ad->cats_ids) ? $ad->cats_ids : json_decode($ad->cats_ids, true);
                $selectedCatsIds = is_array($selectedCatsIds) ? $selectedCatsIds : [];

                if (!empty($selectedCatsIds) && $selectedCatsIds[0] != 'all') {
                    $cats = \App\Models\Category::whereIn('id', $selectedCatsIds)->get();
                } else {
                    $cats = \App\Models\Category::where('company_id', $ad->company->id)->get();
                }

                return $cats->pluck('name')->implode('<br>');
            } else {
                return '---';
            }
        })
        ->addColumn('prod', function ($ad) {
            if ($ad->company && $ad->company->has_product) {
                $selectedProdsIds = is_array($ad->product_ids) ? $ad->product_ids : json_decode($ad->product_ids, true);
                $selectedProdsIds = is_array($selectedProdsIds) ? $selectedProdsIds : [];
                $products = Product::whereIn('id', $selectedProdsIds)->get();
                return $products->pluck('name')->implode('<br>');
            } else {
                return '---';
            }
        })
        ->addColumn('img', function ($ad) {
            $url = new_asset($ad->image);
            return '<a href="' . $url . '" target="_blank"> مشاهدة</a>';
        })
          ->addColumn('link', function ($ad) {
            $themeId = ($ad->company && $ad->company->setting) ? ($ad->company->setting->theme_id ?? '') : '';
            $domain = $ad->company->domains?->url ?? '';

            if (!$domain) {
                return 'لا يوجد رابط';
            } else {
                $domain = rtrim($domain, '/');
                if (!preg_match('/^https?:\/\//', $domain)) {
                    $domain = 'http://' . $domain;
                }
                $url = $domain . '/' . $ad->id;
                return '<a target="_blank" href="' . $url . '">الرابط</a>';
            }
        })
        ->addColumn('statistics', function ($ad) {
            return '<a href="' . route('ads_details.index', ['ads_id' => $ad->id]) . '">مشاهدة الاحصائيات</a>';
        })
      ->addColumn('qr_code', function ($ad) {
           $url = new_asset($ad->qr_code);
            return '<img src="'.$url.'">';
        })
        ->addColumn('actions', function ($ad) {
            $companyId = $ad->company ? $ad->company->id : '';

          
            return '
            <div class="dropdown">
                <button class="btn btn-sm btn-primary dropdown-toggle" type="button" id="actionsDropdown' . $ad->id . '" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                الإجراءات
                </button>
                <div class="dropdown-menu" aria-labelledby="actionsDropdown' . $ad->id . '">
                <a class="dropdown-item bg-primary-light text-primary" href="'. route('excel.export',$ad->id).'">تصدير اكسيل</a>
                <a class="dropdown-item bg-success-light text-success" href="'. route('ads_.edit',$ad->id).'">تعديل  </a>
                <form action="' . route('ads_.destroy', ['ads_' => $ad->id, 'comp_id' => $companyId ]) . '" method="POST" onsubmit="return confirm(\'هل أنت متأكد من الحذف ؟ \');" style="display:inline;">
                    ' . csrf_field() . '
                    ' . method_field('DELETE') . '
                    <button type="submit" class="dropdown-item bg-warning-light text-warning">
                    حذف
                    </button>
                </form>
                </div>
            </div>
            ';
        })
        ->rawColumns(['img', 'link', 'statistics','actions','cat','prod' ,'qr_code'])
        ->make(true);
}

    public function show($id)
    {
        return Ads::with('company','company.domains')->find($id);
    }

    public function create()
    {
    }
    public function store($request)
    {
      $new = new Ads();

      if (is_array($request->product_ids) && isset($request->product_ids[0]) && $request->product_ids[0] === 'all')
        {
            $products = Product::where('company_id',$request->company_id)->get();
            foreach($products as $one)
            {
                $prods_ids[] = $one->id;
            }
            $new->product_ids = json_encode($prods_ids);
        }

        else
        {
             $new->product_ids = json_encode($request->product_ids);
        }


        if (is_array($request->product_ids) && isset($request->product_ids[0]) && $request->product_ids[0] === 'all') {
            $cats = Category::where('company_id', $request->company_id)->get();
            $cat_ids = [];
            foreach ($cats as $one) {
                $cat_ids[] = $one->id;
            }
            $new->cats_ids = !empty($cat_ids) ? json_encode($cat_ids) : null;
        } elseif (!empty($request->cats_ids)) {
            $new->cats_ids = json_encode($request->cats_ids);
        } else {
            $new->cats_ids = null;
        }
    //  dd( $new->cats_ids );
        $new->name = $request->name;
        $new->start_date = $request->start_date;
        $new->end_date = $request->end_date ?? null;
        $new->amount_per_day = $request->amount_per_day;
        $new->company_id = $request->company_id;
        $new->phone = $request->phone;
        // $new->product_ids = json_encode($request->product_ids);
        // $new->cats_ids = json_encode($request->cats_ids );
        $new->status = 'active';
        $new->note = $request->note ?? null;
        $new->number_days = $request->number_days;
        $new->total_amount = $request->total_amount;
        $new->created_by = Auth::user()->id;

        if ($request->hasFile('image')) {
            $path = UploadImage('ads/image', $request->image);
        }
         $new->image = $path ?? null;
        $new->save();
        // dd($request->all());
        return $new;

    }

    public function update($request,$id)
    {
            $new =  Ads::with('company')->findOrFail($id);
            $new->name = $request->name;
            $new->start_date = $request->start_date;
            $new->end_date = $request->end_date ?? null;
            $new->amount_per_day = $request->amount_per_day;
            $new->product_ids = json_encode($request->product_ids);
            $new->cats_ids = json_encode($request->cats_ids );
            $new->status = 'active';
            $new->note = $request->note ?? null;
            $new->number_days = $request->number_days;
            $new->total_amount = $request->total_amount;
            $new->phone = $request->phone;

            $new->updated_by = Auth::user()->id;
            if ($request->hasFile('image')) {
                $path = UploadImage('ads/image', $request->image);
            }
            $new->image = $path ?? $new->image;
            $new->save();
            return $new;
    }

    public function destroy($id)
    {
        $ads = Ads::findOrFail($id);
        $ads->delete();

        $data =  Ads::with('company')->get();
        return $data;
    }

    public function getAll(Request $request)
    {

        return  Ads::with('company')
                      ->when($request->company_id, function ($query) use ($request) {
                                $query->where('company_id', $request->company_id);
                        })
                     ->get();

    }

}