<link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" />
<link rel="stylesheet" href="{{ asset('assets/css/custom.css') }}">

<div class="row">
    <div class="col-12">
        <div class="card mb-30 radius-20">
            <div class="card-body pt-30">
                <form action="{{ route('companies.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf

                    <div class="contact-account-setting media-body d-flex justify-content-center align-items-center"
                        style="background: #eeeff2; border-radius: 12px; padding: 20px 0 15px 0; margin-bottom: 24px; box-shadow: 0 2px 8px rgba(0,0,0,0.04);">
                        <h4 class="mb-0"
                            style="font-weight: bold; letter-spacing: 1px; text-align: center; padding-right: 10px;">
                            إضافة مشروع جديد
                        </h4>
                    </div>

                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group mb-4">
                                <label for="vendor_name" class="mb-2 black bold">اسم المشروع</label>
                                <input type="text" class="theme-input-style" id="vendor_name" name="name"
                                    placeholder="اكتب اسم المشروع هنا">
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group mb-4">
                                <label for="vendor_slug" class="mb-2 black bold">المعرف (Slug)</label>
                                <input type="text" class="theme-input-style mb-2" name="slug" id="vendor_slug"
                                    placeholder="اكتب المعرف هنا">
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="form-group mb-4">
                                <label for="domain" class="mb-2 black bold">النطاق (domain)</label>
                                <select class="form-control mb-5" id="domain" name="domain" required >
                                    @foreach($domain as $d)
                                    <option value="{{ $d->id }}" selected>{{ $d->url }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group mb-4">
                                <label for="vendor_logo" class="mb-2 black bold d-block">اللوجو</label>
                                <input type="file" class="form-control mb-5" id="vendor_logo" name="logo">
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group mb-4">
                                <label for="vendor_contact" class="mb-2 black bold">معلومات التواصل</label>
                                <input type="number" class="theme-input-style" id="vendor_contact" name="phone"
                                    placeholder="رقم الهاتف ">
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-group mb-4">
                                <label for="theme_id" class="mb-2 black bold">الثيم</label>
                                @php $themes = App\Models\Theme::all(); @endphp
                                @foreach($themes as $theme)
                                <label
                                    style="cursor: pointer; display: inline-flex; align-items: center; margin-right: 12px;">
                                    <input type="radio" name="theme_id" value="{{ $theme->id }}" style="display:none;">
                                    <img src="{{ new_asset($theme->image) }}" class="theme-radio-img" alt="Theme Image">
                                </label>
                                @endforeach
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-group mb-4">
                                <label for="vendor_desc" class="mb-2 black bold">الوصف</label>
                                <textarea class="theme-input-style" id="vendor_desc" name="description"
                                    placeholder="نبذة عن المشروع"></textarea>
                            </div>
                        </div>

                        <div class="d-flex justify-content-center pt-3" style="padding-bottom: 10px;">
                            <button type="submit" class="btn btn-primary ml-3">حفظ</button>
                            <button type="reset" class="btn btn-secondary">إلغاء</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


