<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" />
<link rel="stylesheet" href="{{ asset('assets/css/custom.css') }}">

<style>
table.dataTable thead th,
table.dataTable thead td,
table.dataTable tfoot th,
table.dataTable tfoot td {
    text-align: justify !important;
}
</style>
<div class="row">
    <div class="col-12">

        <div class="card mb-30 radius-20">
            <div class="card-body pt-30">
                <h4 class="font-20 ">الفروع</h4>
                <div class="add-new-contact ml-20">
                    <a href="#" class="bg-success-light text-success btn ui-sortable-handle" data-toggle="modal"
                        data-target="#projectAddModal" style="float: left;">
                        فرع جديد
                    </a>
                </div>
                <div id="projectAddModal" class="modal fade">
                    <div class="modal-dialog modal-dialog-centered modal-xl">
                        <div class="modal-content">
                            <!-- Modal Body -->
                            <div class="modal-body">
                                <form action="{{ route('cats.store')}}" method="POST" enctype="multipart/form-data">
                                    @csrf
                                    <div class="contact-account-setting media-body d-flex justify-content-between align-items-center"
                                        style="background: #e3e4e6; border-radius: 12px; padding-top: 20px; padding-bottom: 15px; margin-bottom: 24px; box-shadow: 0 2px 8px rgba(0,0,0,0.04);">
                                        <h4 class="mb-0"
                                            style="font-weight: bold; letter-spacing: 1px; text-align: left;padding-right: 10px;">
                                            إضف جديد</h4>
                                        <button type="button" class="close ml-2" data-dismiss="modal" aria-label="Close"
                                            style="padding-left: 10px;font-size: 2rem; background: none; border: none;">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    @php
                                    $company = App\Models\Company::find(request()->get('id'));
                                    $name = $company ? $company->name : '';
                                    $theme_id = $company ? $company->setting->theme_id : '';

                                    @endphp
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group mb-4">
                                                <label for="name" class="mb-2 black bold">اسم الفرع <span
                                                        class="text-danger">*</span></label>
                                                <input type="text" class="theme-input-style" id="name" name="name"
                                                    placeholder="أدخل اسم الفرع">
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group mb-4">
                                                <label for="geex-input-whatsapp" class="form-label">رقم واتساب</label>
                                                <div class="input-wrapper input-icon position-relative">
                                                    <div class="input-group">
                                                        <span class="input-group-text p-0" style="min-width: 110px;">
                                                            <img id="selected-whatsapp-flag-img" src="{{ asset('assets/flags/sa.png') }}" alt="flag" style="width: 24px; height: 18px; margin-right: 5px;">
                                                            <select name="whatsapp_country_code" id="whatsapp-country-code-select" class="form-select border-0 bg-transparent px-2" style="width: 80px;" required>
                                                                <option value="+966" selected data-flag="sa" data-flag-src="{{ asset('assets/flags/sa.png') }}">+966</option>
                                                                <option value="+20" data-flag="eg" data-flag-src="{{ asset('assets/flags/eg.png') }}">+20</option>
                                                                <option value="+971" data-flag="ae" data-flag-src="{{ asset('assets/flags/ae.png') }}">+971</option>
                                                                <option value="+965" data-flag="kw" data-flag-src="{{ asset('assets/flags/kw.png') }}">+965</option>
                                                                <option value="+964" data-flag="iq" data-flag-src="{{ asset('assets/flags/iq.png') }}">+964</option>
                                                                <option value="+962" data-flag="jo" data-flag-src="{{ asset('assets/flags/jo.png') }}">+962</option>
                                                                <option value="+963" data-flag="sy" data-flag-src="{{ asset('assets/flags/sy.png') }}">+963</option>
                                                                <option value="+968" data-flag="om" data-flag-src="{{ asset('assets/flags/om.png') }}">+968</option>
                                                                <option value="+973" data-flag="bh" data-flag-src="{{ asset('assets/flags/bh.png') }}">+973</option>
                                                                <option value="+974" data-flag="qa" data-flag-src="{{ asset('assets/flags/qa.png') }}">+974</option>
                                                            </select>
                                                        </span>
                                                        <input id="geex-input-whatsapp" type="text" name="whatsapp" placeholder="أدخل رقم واتساب" class="form-control" required inputmode="numeric" pattern="[0-9]*" oninput="this.value = this.value.replace(/[^0-9]/g, '');">
                                                        <span class="input-group-text"><i class="uil uil-whatsapp"></i></span>
                                                    </div>
                                                    <span id="whatsapp-validity-msg" class="mt-2 d-block" style="font-size: 0.95rem;"></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group mb-4">
                                                <label for="geex-input-phone" class="form-label">رقم للتواصل</label>
                                                <div class="input-wrapper input-icon position-relative">
                                                    <div class="input-group">
                                                        <span class="input-group-text p-0" style="min-width: 110px;">
                                                            <img id="selected-phone-flag-img" src="{{ asset('assets/flags/sa.png') }}" alt="flag" style="width: 24px; height: 18px; margin-right: 5px;">
                                                            <select name="phone_country_code" id="phone-country-code-select" class="form-select border-0 bg-transparent px-2" style="width: 80px;" required>
                                                                <option value="+966" selected data-flag="sa" data-flag-src="{{ asset('assets/flags/sa.png') }}">+966</option>
                                                                <option value="+20" data-flag="eg" data-flag-src="{{ asset('assets/flags/eg.png') }}">+20</option>
                                                                <option value="+971" data-flag="ae" data-flag-src="{{ asset('assets/flags/ae.png') }}">+971</option>
                                                                <option value="+965" data-flag="kw" data-flag-src="{{ asset('assets/flags/kw.png') }}">+965</option>
                                                                <option value="+964" data-flag="iq" data-flag-src="{{ asset('assets/flags/iq.png') }}">+964</option>
                                                                <option value="+962" data-flag="jo" data-flag-src="{{ asset('assets/flags/jo.png') }}">+962</option>
                                                                <option value="+963" data-flag="sy" data-flag-src="{{ asset('assets/flags/sy.png') }}">+963</option>
                                                                <option value="+968" data-flag="om" data-flag-src="{{ asset('assets/flags/om.png') }}">+968</option>
                                                                <option value="+973" data-flag="bh" data-flag-src="{{ asset('assets/flags/bh.png') }}">+973</option>
                                                                <option value="+974" data-flag="qa" data-flag-src="{{ asset('assets/flags/qa.png') }}">+974</option>
                                                            </select>
                                                        </span>
                                                        <input id="geex-input-phone" type="text" name="phone" placeholder="أدخل رقم للتواصل" class="form-control" required inputmode="numeric" pattern="[0-9]*" oninput="this.value = this.value.replace(/[^0-9]/g, '');">
                                                        <span class="input-group-text"><i class="uil uil-phone"></i></span>
                                                    </div>
                                                    <span id="phone-validity-msg" class="mt-2 d-block" style="font-size: 0.95rem;"></span>
                                                </div>
                                            </div>
                                        </div>
                                        <script>
                                        document.addEventListener('DOMContentLoaded', function () {
                                            // Whatsapp
                                            const whatsappSelect = document.getElementById('whatsapp-country-code-select');
                                            const whatsappFlagImg = document.getElementById('selected-whatsapp-flag-img');
                                            const whatsappInput = document.getElementById('geex-input-whatsapp');
                                            const whatsappMsgSpan = document.getElementById('whatsapp-validity-msg');
                                            // Phone
                                            const phoneSelect = document.getElementById('phone-country-code-select');
                                            const phoneFlagImg = document.getElementById('selected-phone-flag-img');
                                            const phoneInput = document.getElementById('geex-input-phone');
                                            const phoneMsgSpan = document.getElementById('phone-validity-msg');

                                            function updateFlag(select, flagImg) {
                                                const selectedOption = select.options[select.selectedIndex];
                                                const flagSrc = selectedOption.getAttribute('data-flag-src');
                                                if(flagSrc) {
                                                    flagImg.src = flagSrc;
                                                }
                                            }

                                            function validatePhone(select, input, msgSpan) {
                                                const countryCode = select.value;
                                                const phone = input.value.trim();
                                                let valid = false;
                                                let regex;
                                                switch(countryCode) {
                                                    case '+966': regex = /^5\d{8}$/; break; // Saudi Arabia
                                                    case '+20': regex = /^1\d{9}$/; break; // Egypt
                                                    case '+971': regex = /^5\d{8}$/; break; // UAE
                                                    case '+965': regex = /^[569]\d{7}$/; break; // Kuwait
                                                    case '+964': regex = /^7\d{9}$/; break; // Iraq
                                                    case '+962': regex = /^7\d{8}$/; break; // Jordan
                                                    case '+963': regex = /^9\d{8}$/; break; // Syria
                                                    case '+968': regex = /^9\d{7}$/; break; // Oman
                                                    case '+973': regex = /^3\d{7}$/; break; // Bahrain
                                                    case '+974': regex = /^3\d{7}$/; break; // Qatar
                                                    default: regex = /^\d+$/;
                                                }
                                                if (regex.test(phone)) valid = true;
                                                if (phone.length === 0) {
                                                    msgSpan.textContent = '';
                                                    msgSpan.classList.remove('text-success', 'text-danger');
                                                } else if (valid) {
                                                    msgSpan.textContent = 'الرقم صحيح';
                                                    msgSpan.classList.add('text-success');
                                                    msgSpan.classList.remove('text-danger');
                                                } else {
                                                    msgSpan.textContent = 'الرقم غير صحيح';
                                                    msgSpan.classList.add('text-danger');
                                                    msgSpan.classList.remove('text-success');
                                                }
                                            }

                                            whatsappSelect.addEventListener('change', function() {
                                                updateFlag(whatsappSelect, whatsappFlagImg);
                                                validatePhone(whatsappSelect, whatsappInput, whatsappMsgSpan);
                                            });
                                            whatsappInput.addEventListener('input', function() {
                                                validatePhone(whatsappSelect, whatsappInput, whatsappMsgSpan);
                                            });
                                            phoneSelect.addEventListener('change', function() {
                                                updateFlag(phoneSelect, phoneFlagImg);
                                                validatePhone(phoneSelect, phoneInput, phoneMsgSpan);
                                            });
                                            phoneInput.addEventListener('input', function() {
                                                validatePhone(phoneSelect, phoneInput, phoneMsgSpan);
                                            });

                                            updateFlag(whatsappSelect, whatsappFlagImg);
                                            validatePhone(whatsappSelect, whatsappInput, whatsappMsgSpan);
                                            updateFlag(phoneSelect, phoneFlagImg);
                                            validatePhone(phoneSelect, phoneInput, phoneMsgSpan);
                                        });
                                        </script>
                                        <div class="col-lg-6">
                                            <div class="form-group mb-4">
                                                <label for="name" class="mb-2 black bold"> رابط إنستجرام </label>
                                                <input type="text" class="theme-input-style" name="instagram"
                                                    placeholder="أدخل رابط إنستجرام ">
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group mb-4">
                                                <label for="name" class="mb-2 black bold">رابط جوجل ماب </label>
                                                <input type="text" class="theme-input-style" name="google_Map"
                                                    placeholder="أدخل رابط جوجل ماب ">
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group mb-4">
                                                <label for="name" class="mb-2 black bold">رابط جوجل ماب 2</label>
                                                <input type="text" class="theme-input-style" name="google_Map_2"
                                                    placeholder="أدخل رابط جوجل ماب ">
                                            </div>
                                        </div>

                                        @if($theme_id == 2)
                                        <div class="col-lg-6">
                                            <div class="form-group mb-4">
                                                <label for="vendor_logo" class="mb-2 black bold">
                                                    قائمة الطعام (PDF)</label>
                                                <input type="file" class="theme-input-style" name="menu"
                                                    accept="application/pdf">
                                            </div>
                                        </div>
                                        @endif

                                        <div class="col-lg-12">
                                            <div class="form-group mb-4">
                                                <label for="description" class="mb-2 black bold">الوصف</label>
                                                <textarea class="theme-input-style" id="description" name="description"
                                                    rows="3" placeholder="وصف "></textarea>
                                            </div>
                                        </div>
                                        <input type="hidden" name="company_id" value="{{ request()->get('id') }}">
                                    </div>
                                    <div class="d-flex justify-content-center pt-3" style="padding-bottom: 10px;">
                                        <button type="submit" class="btn btn-primary ml-3">حفظ</button>
                                        <button type="reset" class="btn btn-secondary"
                                            data-dismiss="modal">إلغاء</button>
                                    </div>
                                </form>
                            </div>
                            <!-- End Modal Body -->
                        </div>
                    </div>
                </div>
                <div class="table-responsive">
                    <!-- Invoice List Table -->
                    <table class="text-nowrap bg-white dh-table">
                        <thead class="thead-light">
                            <tr>

                                <th>م</th>
                                <th>اسم الفرع</th>
                                <th>عدد الحملات </th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                             @foreach ($data as $one)
                                @php
                                     $ads = App\Models\Ads::where('company_id', request()->get('id'))->get();
                                     $countAds =0;
                                   foreach ($ads as $ad) {
                                        $catsIds = is_array($ad->cats_ids) ? $ad->cats_ids : json_decode($ad->cats_ids, true);
                                        $catsIds = is_array($catsIds) ? $catsIds : [];

                                        if (!empty($catsIds) && ($catsIds[0] === 'all' || in_array($one->id,$catsIds))) {
                                            $countAds ++;
                                        }
                                    }
                                @endphp
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ is_object($one) ? $one->name : '' }}</td>
                                @php
                                   $adss = App\Models\CAtegory::where('company_id', request()->get('id'))->get();
                                @endphp

                                <td><a href="{{ route('ads_.index', array('comp_id' => request()->get('id'),'cat_id' => $one->id)) }}" class="text-primary">
                                        {{ $countAds}}
                                    </a> </td>
                                <td>
                                    <a class="btn btn-sm bg-success-light text-success mr-10" data-toggle="modal"style="display:none;"
                                        data-target="#projectShowModal_{{$one->id}}">التفاصيل</a>
                                    <a class="btn btn-sm bg-info-light text-info mr-10" data-toggle="modal"
                                        data-target="#projectEditModal_{{$one->id}}">تعديل</a>
                                    <form action="{{ route('cats.destroy', $one->id) }}" method="POST"
                                        style="display:inline;">
                                        @csrf
                                        @method('DELETE')
                                        <input type="hidden" name="company_id" value="{{ request()->get('id') }}">
                                        <button type="submit" class="btn btn-sm bg-danger-light text-danger mr-10"
                                            onclick="return confirm('هل أنت متأكد من الحذف ');">حذف</button>
                                    </form>

                                </td>
                            </tr>
                            <div id="projectShowModal_{{$one->id}}" class="modal fade">
                                <div class="modal-dialog modal-dialog-centered modal-xl">
                                    <div class="modal-content">
                                        <!-- Modal Body -->
                                        <div class="modal-body">
                                            <div class="contact-account-setting media-body d-flex justify-content-between align-items-center"
                                                style="background: #e3e4e6; border-radius: 12px; padding-top: 20px; padding-bottom: 15px; margin-bottom: 24px; box-shadow: 0 2px 8px rgba(0,0,0,0.04);">
                                                <h4 class="mb-0"
                                                    style="font-weight: bold; letter-spacing: 1px; text-align: left;padding-right: 10px;">
                                                    عرض التفاصيل </h4>
                                                <button type="button" class="close ml-2" data-dismiss="modal"
                                                    aria-label="Close"
                                                    style="padding-left: 10px;font-size: 2rem; background: none; border: none;">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="row">
                                                <div class="col-lg-6">
                                                    <div class="form-group mb-4">
                                                        <label for="edit_name_{{$one->id}}" class="mb-2 black bold">اسم
                                                            الفرع </label>
                                                        <input type="text" class="theme-input-style" name="name"
                                                            value="{{ $one->name }}" disabled>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="form-group mb-4">
                                                        <label for="show_whatsapp_{{$one->id}}" class="form-label">رقم واتساب</label>
                                                        <div class="input-wrapper input-icon position-relative">
                                                            <div class="input-group">
                                                                <span class="input-group-text p-0" style="min-width: 110px;">
                                                                    @php
                                                                        $whatsappNumber = $one->socialMedia->where('type','whatsapp')->first()?->link ?? '';
                                                                        $countryCode = '';
                                                                        $countryCodes = ['+966', '+20', '+971', '+965', '+964', '+962', '+963', '+968', '+973', '+974'];
                                                                        foreach ($countryCodes as $code) {
                                                                            if ($whatsappNumber && strpos($whatsappNumber, $code) === 0) {
                                                                                $countryCode = $code;
                                                                                break;
                                                                            }
                                                                        }
                                                                        $whatsappCountryCode = $countryCode ?: '+966';
                                                                        $whatsappFlag = [
                                                                            '+966' => 'sa',
                                                                            '+20' => 'eg',
                                                                            '+971' => 'ae',
                                                                            '+965' => 'kw',
                                                                            '+964' => 'iq',
                                                                            '+962' => 'jo',
                                                                            '+963' => 'sy',
                                                                            '+968' => 'om',
                                                                            '+973' => 'bh',
                                                                            '+974' => 'qa',
                                                                        ][$whatsappCountryCode] ?? 'sa';
                                                                    @endphp
                                                                    <img src="{{ asset('assets/flags/'.$whatsappFlag.'.png') }}" alt="flag" style="width: 24px; height: 18px; margin-right: 5px;">
                                                                    <select class="form-select border-0 bg-transparent px-2" style="width: 80px;" disabled>
                                                                        <option value="+966" @if($whatsappCountryCode=='+966') selected @endif>+966</option>
                                                                        <option value="+20" @if($whatsappCountryCode=='+20') selected @endif>+20</option>
                                                                        <option value="+971" @if($whatsappCountryCode=='+971') selected @endif>+971</option>
                                                                        <option value="+965" @if($whatsappCountryCode=='+965') selected @endif>+965</option>
                                                                        <option value="+964" @if($whatsappCountryCode=='+964') selected @endif>+964</option>
                                                                        <option value="+962" @if($whatsappCountryCode=='+962') selected @endif>+962</option>
                                                                        <option value="+963" @if($whatsappCountryCode=='+963') selected @endif>+963</option>
                                                                        <option value="+968" @if($whatsappCountryCode=='+968') selected @endif>+968</option>
                                                                        <option value="+973" @if($whatsappCountryCode=='+973') selected @endif>+973</option>
                                                                        <option value="+974" @if($whatsappCountryCode=='+974') selected @endif>+974</option>
                                                                    </select>
                                                                </span>
                                                                <input type="text" class="form-control" disabled value="{{ $one->socialMedia->where('type','whatsapp')->first()?->link }}">
                                                                <span class="input-group-text"><i class="uil uil-whatsapp"></i></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-lg-6">
                                                    <div class="form-group mb-4">
                                                        <label for="show_phone_{{$one->id}}" class="form-label">رقم للتواصل</label>
                                                        <div class="input-wrapper input-icon position-relative">
                                                            <div class="input-group">
                                                                <span class="input-group-text p-0" style="min-width: 110px;">
                                                                    @php
                                                                        $phoneNumber = $one->socialMedia->where('type','phone')->first()?->link ?? '';
                                                                        $phoneCountryCode = '';
                                                                        if ($phoneNumber) {
                                                                            $countryCodes = ['+966', '+20', '+971', '+965', '+964', '+962', '+963', '+968', '+973', '+974'];
                                                                            foreach ($countryCodes as $code) {
                                                                                if (strpos($phoneNumber, $code) === 0) {
                                                                                    $phoneCountryCode = $code;
                                                                                    break;
                                                                                }
                                                                            }
                                                                        }
                                                                        $phoneCountryCode = $phoneCountryCode ?: '+966';
                                                                        $phoneFlag = [
                                                                            '+966' => 'sa',
                                                                            '+20' => 'eg',
                                                                            '+971' => 'ae',
                                                                            '+965' => 'kw',
                                                                            '+964' => 'iq',
                                                                            '+962' => 'jo',
                                                                            '+963' => 'sy',
                                                                            '+968' => 'om',
                                                                            '+973' => 'bh',
                                                                            '+974' => 'qa',
                                                                        ][$phoneCountryCode] ?? 'sa';
                                                                    @endphp
                                                                    <img src="{{ asset('assets/flags/'.$phoneFlag.'.png') }}" alt="flag" style="width: 24px; height: 18px; margin-right: 5px;">
                                                                    <select class="form-select border-0 bg-transparent px-2" style="width: 80px;" disabled>
                                                                        <option value="+966" @if($phoneCountryCode=='+966') selected @endif>+966</option>
                                                                        <option value="+20" @if($phoneCountryCode=='+20') selected @endif>+20</option>
                                                                        <option value="+971" @if($phoneCountryCode=='+971') selected @endif>+971</option>
                                                                        <option value="+965" @if($phoneCountryCode=='+965') selected @endif>+965</option>
                                                                        <option value="+964" @if($phoneCountryCode=='+964') selected @endif>+964</option>
                                                                        <option value="+962" @if($phoneCountryCode=='+962') selected @endif>+962</option>
                                                                        <option value="+963" @if($phoneCountryCode=='+963') selected @endif>+963</option>
                                                                        <option value="+968" @if($phoneCountryCode=='+968') selected @endif>+968</option>
                                                                        <option value="+973" @if($phoneCountryCode=='+973') selected @endif>+973</option>
                                                                        <option value="+974" @if($phoneCountryCode=='+974') selected @endif>+974</option>
                                                                    </select>
                                                                </span>
                                                                <input type="text" class="form-control" disabled value="{{ $one->socialMedia->where('type','phone')->first()?->link }}">
                                                                <span class="input-group-text"><i class="uil uil-phone"></i></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="form-group mb-4">
                                                        <label for="edit_name_{{$one->id}}" class="mb-2 black bold">
                                                            رابط إنستجرام </label>
                                                        <input type="text" class="theme-input-style" name="instagram"
                                                            disabled
                                                            value="{{ $one->socialMedia->where('type','instagram')->first()?->link}}">
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="form-group mb-4">
                                                        <label for="edit_name_{{$one->id}}" class="mb-2 black bold">
                                                            رابط جوجل ماب </label>
                                                        <input type="text" class="theme-input-style" name="google_Map"
                                                            disabled
                                                            value="{{ $one->socialMedia->where('type','google_Map')->first()?->link }}">
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="form-group mb-4">
                                                        <label for="edit_name_{{$one->id}}" class="mb-2 black bold">
                                                           2 رابط جوجل ماب </label>
                                                        <input type="text" class="theme-input-style" name="google_Map_2"
                                                            disabled
                                                            value="{{ $one->socialMedia->where('type','google_Map_2')->first()?->link }}">
                                                    </div>
                                                </div>

                                                <div class="col-lg-12">
                                                    <div class="form-group mb-4">
                                                        <label for="edit_description_{{$one->id}}"
                                                            class="mb-2 black bold">الوصف</label>
                                                        <textarea class="theme-input-style"
                                                            id="edit_description_{{$one->id}}" name="description"
                                                            rows="3" disabled
                                                            placeholder="وصف ">{{ $one->description }}</textarea>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                        <!-- End Modal Body -->
                                    </div>
                                </div>
                            </div>
                            <div id="projectEditModal_{{$one->id}}" class="modal fade">
                                <div class="modal-dialog modal-dialog-centered modal-xl">
                                    <div class="modal-content">
                                        <!-- Modal Body -->
                                        <div class="modal-body">
                                            <form action="{{ route('cats.update',$one->id) }}" method="POST"
                                                enctype="multipart/form-data">
                                                @csrf
                                                @method('PUT')
                                                <div class="contact-account-setting media-body d-flex justify-content-between align-items-center"
                                                    style="background: #e3e4e6; border-radius: 12px; padding-top: 20px; padding-bottom: 15px; margin-bottom: 24px; box-shadow: 0 2px 8px rgba(0,0,0,0.04);">
                                                    <h4 class="mb-0"
                                                        style="font-weight: bold; letter-spacing: 1px; text-align: left;padding-right: 10px;">
                                                        تعديل </h4>
                                                    <button type="button" class="close ml-2" data-dismiss="modal"
                                                        aria-label="Close"
                                                        style="padding-left: 10px;font-size: 2rem; background: none; border: none;">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="row">
                                                    <div class="col-lg-6">
                                                        <div class="form-group mb-4">
                                                            <label for="edit_name_{{$one->id}}"
                                                                class="mb-2 black bold">اسم الفرع <span
                                                                    class="text-danger">*</span></label>
                                                            <input type="text" class="theme-input-style" name="name"
                                                                value="{{ $one->name }}">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <div class="form-group mb-4">
                                                            <label for="edit_whatsapp_{{$one->id}}" class="form-label">رقم واتساب</label>
                                                            <div class="input-wrapper input-icon position-relative">
                                                                <div class="input-group">
                                                                    <span class="input-group-text p-0" style="min-width: 110px;">
                                                                        @php
                                                                            $whatsappNumber = $one->socialMedia->where('type','whatsapp')->first()?->link ?? '';
                                                                            $countryCode = '';
                                                                            $countryCodes = ['+966', '+20', '+971', '+965', '+964', '+962', '+963', '+968', '+973', '+974'];
                                                                            foreach ($countryCodes as $code) {
                                                                                if ($whatsappNumber && strpos($whatsappNumber, $code) === 0) {
                                                                                    $countryCode = $code;
                                                                                    break;
                                                                                }
                                                                            }
                                                                            $whatsappCountryCode = $countryCode ?: '+966';
                                                                            $whatsappFlag = [
                                                                                '+966' => 'sa',
                                                                                '+20' => 'eg',
                                                                                '+971' => 'ae',
                                                                                '+965' => 'kw',
                                                                                '+964' => 'iq',
                                                                                '+962' => 'jo',
                                                                                '+963' => 'sy',
                                                                                '+968' => 'om',
                                                                                '+973' => 'bh',
                                                                                '+974' => 'qa',
                                                                            ][$whatsappCountryCode] ?? 'sa';
                                                                            $whatsappNumberOnly = $whatsappNumber;
                                                                            if ($whatsappNumber && strpos($whatsappNumber, $whatsappCountryCode) === 0) {
                                                                                $whatsappNumberOnly = substr($whatsappNumber, strlen($whatsappCountryCode));
                                                                            }
                                                                        @endphp
                                                                        <img id="edit-whatsapp-flag-img-{{$one->id}}" src="{{ asset('assets/flags/'.$whatsappFlag.'.png') }}" alt="flag" style="width: 24px; height: 18px; margin-right: 5px;">
                                                                        <select name="whatsapp_country_code" id="edit-whatsapp-country-code-select-{{$one->id}}" class="form-select border-0 bg-transparent px-2" style="width: 80px;">
                                                                            <option value="+966" @if($whatsappCountryCode=='+966') selected @endif data-flag="sa" data-flag-src="{{ asset('assets/flags/sa.png') }}">+966</option>
                                                                            <option value="+20" @if($whatsappCountryCode=='+20') selected @endif data-flag="eg" data-flag-src="{{ asset('assets/flags/eg.png') }}">+20</option>
                                                                            <option value="+971" @if($whatsappCountryCode=='+971') selected @endif data-flag="ae" data-flag-src="{{ asset('assets/flags/ae.png') }}">+971</option>
                                                                            <option value="+965" @if($whatsappCountryCode=='+965') selected @endif data-flag="kw" data-flag-src="{{ asset('assets/flags/kw.png') }}">+965</option>
                                                                            <option value="+964" @if($whatsappCountryCode=='+964') selected @endif data-flag="iq" data-flag-src="{{ asset('assets/flags/iq.png') }}">+964</option>
                                                                            <option value="+962" @if($whatsappCountryCode=='+962') selected @endif data-flag="jo" data-flag-src="{{ asset('assets/flags/jo.png') }}">+962</option>
                                                                            <option value="+963" @if($whatsappCountryCode=='+963') selected @endif data-flag="sy" data-flag-src="{{ asset('assets/flags/sy.png') }}">+963</option>
                                                                            <option value="+968" @if($whatsappCountryCode=='+968') selected @endif data-flag="om" data-flag-src="{{ asset('assets/flags/om.png') }}">+968</option>
                                                                            <option value="+973" @if($whatsappCountryCode=='+973') selected @endif data-flag="bh" data-flag-src="{{ asset('assets/flags/bh.png') }}">+973</option>
                                                                            <option value="+974" @if($whatsappCountryCode=='+974') selected @endif data-flag="qa" data-flag-src="{{ asset('assets/flags/qa.png') }}">+974</option>
                                                                        </select>
                                                                    </span>
                                                                    <input id="edit-geex-input-whatsapp-{{$one->id}}" type="text" name="whatsapp" placeholder="أدخل رقم واتساب" class="form-control"
                                                                        value="{{ $whatsappNumberOnly }}" inputmode="numeric" pattern="[0-9]*"
                                                                        oninput="this.value = this.value.replace(/[^0-9]/g, '');">
                                                                    <span class="input-group-text"><i class="uil uil-whatsapp"></i></span>
                                                                </div>
                                                                <span id="edit-whatsapp-validity-msg-{{$one->id}}" class="mt-2 d-block" style="font-size: 0.95rem;"></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <script>
                                                        document.addEventListener('DOMContentLoaded', function () {
                                                            const whatsappSelect = document.getElementById('edit-whatsapp-country-code-select-{{$one->id}}');
                                                            const whatsappFlagImg = document.getElementById('edit-whatsapp-flag-img-{{$one->id}}');
                                                            const whatsappInput = document.getElementById('edit-geex-input-whatsapp-{{$one->id}}');
                                                            const whatsappMsgSpan = document.getElementById('edit-whatsapp-validity-msg-{{$one->id}}');

                                                            function updateFlag(select, flagImg) {
                                                                const selectedOption = select.options[select.selectedIndex];
                                                                const flagSrc = selectedOption.getAttribute('data-flag-src');
                                                                if(flagSrc) {
                                                                    flagImg.src = flagSrc;
                                                                }
                                                            }

                                                            function validatePhone(select, input, msgSpan) {
                                                                const countryCode = select.value;
                                                                const phone = input.value.trim();
                                                                let valid = false;
                                                                let regex;
                                                                switch(countryCode) {
                                                                    case '+966': regex = /^5\d{8}$/; break; // Saudi Arabia
                                                                    case '+20': regex = /^1\d{9}$/; break; // Egypt
                                                                    case '+971': regex = /^5\d{8}$/; break; // UAE
                                                                    case '+965': regex = /^[569]\d{7}$/; break; // Kuwait
                                                                    case '+964': regex = /^7\d{9}$/; break; // Iraq
                                                                    case '+962': regex = /^7\d{8}$/; break; // Jordan
                                                                    case '+963': regex = /^9\d{8}$/; break; // Syria
                                                                    case '+968': regex = /^9\d{7}$/; break; // Oman
                                                                    case '+973': regex = /^3\d{7}$/; break; // Bahrain
                                                                    case '+974': regex = /^3\d{7}$/; break; // Qatar
                                                                    default: regex = /^\d+$/;
                                                                }
                                                                if (regex.test(phone)) valid = true;
                                                                if (phone.length === 0) {
                                                                    msgSpan.textContent = '';
                                                                    msgSpan.classList.remove('text-success', 'text-danger');
                                                                } else if (valid) {
                                                                    msgSpan.textContent = 'الرقم صحيح';
                                                                    msgSpan.classList.add('text-success');
                                                                    msgSpan.classList.remove('text-danger');
                                                                } else {
                                                                    msgSpan.textContent = 'الرقم غير صحيح';
                                                                    msgSpan.classList.add('text-danger');
                                                                    msgSpan.classList.remove('text-success');
                                                                }
                                                            }

                                                            if (whatsappSelect && whatsappFlagImg && whatsappInput && whatsappMsgSpan) {
                                                                whatsappSelect.addEventListener('change', function() {
                                                                    updateFlag(whatsappSelect, whatsappFlagImg);
                                                                    validatePhone(whatsappSelect, whatsappInput, whatsappMsgSpan);
                                                                });
                                                                whatsappInput.addEventListener('input', function() {
                                                                    validatePhone(whatsappSelect, whatsappInput, whatsappMsgSpan);
                                                                });
                                                                updateFlag(whatsappSelect, whatsappFlagImg);
                                                                validatePhone(whatsappSelect, whatsappInput, whatsappMsgSpan);
                                                            }
                                                        });
                                                    </script>
                                                    <!-- رقم للتواصل -->
                                                    <div class="col-lg-6">
                                                        <div class="form-group mb-4">
                                                            <label for="edit_phone_{{$one->id}}" class="form-label">رقم للتواصل</label>
                                                            <div class="input-wrapper input-icon position-relative">
                                                                <div class="input-group">
                                                                    <span class="input-group-text p-0" style="min-width: 110px;">
                                                                        @php
                                                                            $phoneNumber = $one->socialMedia->where('type','phone')->first()?->link ?? '';
                                                                            $phoneCountryCode = '';
                                                                            $countryCodes = ['+966', '+20', '+971', '+965', '+964', '+962', '+963', '+968', '+973', '+974'];
                                                                            foreach ($countryCodes as $code) {
                                                                                if ($phoneNumber && strpos($phoneNumber, $code) === 0) {
                                                                                    $phoneCountryCode = $code;
                                                                                    break;
                                                                                }
                                                                            }
                                                                            $phoneCountryCode = $phoneCountryCode ?: '+966';
                                                                            $phoneFlag = [
                                                                                '+966' => 'sa',
                                                                                '+20' => 'eg',
                                                                                '+971' => 'ae',
                                                                                '+965' => 'kw',
                                                                                '+964' => 'iq',
                                                                                '+962' => 'jo',
                                                                                '+963' => 'sy',
                                                                                '+968' => 'om',
                                                                                '+973' => 'bh',
                                                                                '+974' => 'qa',
                                                                            ][$phoneCountryCode] ?? 'sa';
                                                                            $phoneNumberOnly = $phoneNumber;
                                                                            if ($phoneNumber && strpos($phoneNumber, $phoneCountryCode) === 0) {
                                                                                $phoneNumberOnly = substr($phoneNumber, strlen($phoneCountryCode));
                                                                            }
                                                                        @endphp
                                                                        <img id="edit-phone-flag-img-{{$one->id}}" src="{{ asset('assets/flags/'.$phoneFlag.'.png') }}" alt="flag" style="width: 24px; height: 18px; margin-right: 5px;">
                                                                        <select name="phone_country_code" id="edit-phone-country-code-select-{{$one->id}}" class="form-select border-0 bg-transparent px-2" style="width: 80px;">
                                                                            <option value="+966" @if($phoneCountryCode=='+966') selected @endif data-flag="sa" data-flag-src="{{ asset('assets/flags/sa.png') }}">+966</option>
                                                                            <option value="+20" @if($phoneCountryCode=='+20') selected @endif data-flag="eg" data-flag-src="{{ asset('assets/flags/eg.png') }}">+20</option>
                                                                            <option value="+971" @if($phoneCountryCode=='+971') selected @endif data-flag="ae" data-flag-src="{{ asset('assets/flags/ae.png') }}">+971</option>
                                                                            <option value="+965" @if($phoneCountryCode=='+965') selected @endif data-flag="kw" data-flag-src="{{ asset('assets/flags/kw.png') }}">+965</option>
                                                                            <option value="+964" @if($phoneCountryCode=='+964') selected @endif data-flag="iq" data-flag-src="{{ asset('assets/flags/iq.png') }}">+964</option>
                                                                            <option value="+962" @if($phoneCountryCode=='+962') selected @endif data-flag="jo" data-flag-src="{{ asset('assets/flags/jo.png') }}">+962</option>
                                                                            <option value="+963" @if($phoneCountryCode=='+963') selected @endif data-flag="sy" data-flag-src="{{ asset('assets/flags/sy.png') }}">+963</option>
                                                                            <option value="+968" @if($phoneCountryCode=='+968') selected @endif data-flag="om" data-flag-src="{{ asset('assets/flags/om.png') }}">+968</option>
                                                                            <option value="+973" @if($phoneCountryCode=='+973') selected @endif data-flag="bh" data-flag-src="{{ asset('assets/flags/bh.png') }}">+973</option>
                                                                            <option value="+974" @if($phoneCountryCode=='+974') selected @endif data-flag="qa" data-flag-src="{{ asset('assets/flags/qa.png') }}">+974</option>
                                                                        </select>
                                                                    </span>
                                                                    <input id="edit-geex-input-phone-{{$one->id}}" type="text" name="phone" placeholder="أدخل رقم للتواصل" class="form-control"
                                                                        value="{{ $phoneNumberOnly }}" inputmode="numeric" pattern="[0-9]*"
                                                                        oninput="this.value = this.value.replace(/[^0-9]/g, '');">
                                                                    <span class="input-group-text"><i class="uil uil-phone"></i></span>
                                                                </div>
                                                                <span id="edit-phone-validity-msg-{{$one->id}}" class="mt-2 d-block" style="font-size: 0.95rem;"></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <script>
                                                        document.addEventListener('DOMContentLoaded', function () {
                                                            const phoneSelect = document.getElementById('edit-phone-country-code-select-{{$one->id}}');
                                                            const phoneFlagImg = document.getElementById('edit-phone-flag-img-{{$one->id}}');
                                                            const phoneInput = document.getElementById('edit-geex-input-phone-{{$one->id}}');
                                                            const phoneMsgSpan = document.getElementById('edit-phone-validity-msg-{{$one->id}}');

                                                            function updateFlag(select, flagImg) {
                                                                const selectedOption = select.options[select.selectedIndex];
                                                                const flagSrc = selectedOption.getAttribute('data-flag-src');
                                                                if(flagSrc) {
                                                                    flagImg.src = flagSrc;
                                                                }
                                                            }

                                                            function validatePhone(select, input, msgSpan) {
                                                                const countryCode = select.value;
                                                                const phone = input.value.trim();
                                                                let valid = false;
                                                                let regex;
                                                                switch(countryCode) {
                                                                    case '+966': regex = /^5\d{8}$/; break; // Saudi Arabia
                                                                    case '+20': regex = /^1\d{9}$/; break; // Egypt
                                                                    case '+971': regex = /^5\d{8}$/; break; // UAE
                                                                    case '+965': regex = /^[569]\d{7}$/; break; // Kuwait
                                                                    case '+964': regex = /^7\d{9}$/; break; // Iraq
                                                                    case '+962': regex = /^7\d{8}$/; break; // Jordan
                                                                    case '+963': regex = /^9\d{8}$/; break; // Syria
                                                                    case '+968': regex = /^9\d{7}$/; break; // Oman
                                                                    case '+973': regex = /^3\d{7}$/; break; // Bahrain
                                                                    case '+974': regex = /^3\d{7}$/; break; // Qatar
                                                                    default: regex = /^\d+$/;
                                                                }
                                                                if (regex.test(phone)) valid = true;
                                                                if (phone.length === 0) {
                                                                    msgSpan.textContent = '';
                                                                    msgSpan.classList.remove('text-success', 'text-danger');
                                                                } else if (valid) {
                                                                    msgSpan.textContent = 'الرقم صحيح';
                                                                    msgSpan.classList.add('text-success');
                                                                    msgSpan.classList.remove('text-danger');
                                                                } else {
                                                                    msgSpan.textContent = 'الرقم غير صحيح';
                                                                    msgSpan.classList.add('text-danger');
                                                                    msgSpan.classList.remove('text-success');
                                                                }
                                                            }

                                                            if (phoneSelect && phoneFlagImg && phoneInput && phoneMsgSpan) {
                                                                phoneSelect.addEventListener('change', function() {
                                                                    updateFlag(phoneSelect, phoneFlagImg);
                                                                    validatePhone(phoneSelect, phoneInput, phoneMsgSpan);
                                                                });
                                                                phoneInput.addEventListener('input', function() {
                                                                    validatePhone(phoneSelect, phoneInput, phoneMsgSpan);
                                                                });
                                                                updateFlag(phoneSelect, phoneFlagImg);
                                                                validatePhone(phoneSelect, phoneInput, phoneMsgSpan);
                                                            }
                                                        });
                                                    </script>
                                                    <div class="col-lg-6">
                                                        <div class="form-group mb-4">
                                                            <label for="edit_name_{{$one->id}}" class="mb-2 black bold">
                                                                رابط إنستجرام </label>
                                                            <input type="text" class="theme-input-style"
                                                                name="instagram"
                                                                value="{{ $one->socialMedia->where('type','instagram')->first()?->link}}">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <div class="form-group mb-4">
                                                            <label for="edit_name_{{$one->id}}" class="mb-2 black bold">
                                                                رابط جوجل ماب </label>
                                                            <input type="text" class="theme-input-style"
                                                                name="google_Map"
                                                                value="{{ $one->socialMedia->where('type','google_Map')->first()?->link }}">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <div class="form-group mb-4">
                                                            <label for="edit_name_{{$one->id}}" class="mb-2 black bold">
                                                              2  رابط جوجل ماب </label>
                                                            <input type="text" class="theme-input-style"
                                                                name="google_Map_2"
                                                                value="{{ $one->socialMedia->where('type','google_Map_2')->first()?->link }}">
                                                        </div>
                                                    </div>
                                                    @if($theme_id == 2)
                                                    <div class="col-lg-6">
                                                        <div class="form-group mb-4">
                                                            <label class="mb-2 black bold">
                                                                قائمة الطعام (PDF)</label>
                                                            <input type="file" class="theme-input-style" name="menu"
                                                                accept="application/pdf">
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <a href="{{ isset($one->socialMedia) ? new_asset($one->socialMedia->where('type','menu')->where('id',$one->id)->first()?->link):'' }}"
                                                                target="_blank">
                                                                <img src="{{isset($one->socialMedia) ? new_asset($one->socialMedia->where('type','menu')->where('id',$one->id)->first()?->link):''  }}"
                                                                    style="width: 100px; height: auto; border: 2px solid transparent; border-radius: 8px;">
                                                            </a>
                                                        </div>
                                                    </div>
                                                    @endif

                                                    <div class="col-lg-12">
                                                        <div class="form-group mb-4">
                                                            <label for="edit_description_{{$one->id}}"
                                                                class="mb-2 black bold">الوصف</label>
                                                            <textarea class="theme-input-style"
                                                                id="edit_description_{{$one->id}}" name="description"
                                                                rows="3"
                                                                placeholder="وصف ">{{ $one->description }}</textarea>
                                                        </div>
                                                    </div>
                                                    <input type="hidden" name="company_id"
                                                        value="{{ request()->get('id') }}">
                                                </div>
                                                <div class="d-flex justify-content-center pt-3"
                                                    style="padding-bottom: 10px;">
                                                    <button type="submit" class="btn btn-primary ml-3">تعديل</button>
                                                    <button type="reset" class="btn btn-secondary"
                                                        data-dismiss="modal">إلغاء</button>
                                                </div>
                                            </form>
                                        </div>
                                        <!-- End Modal Body -->
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </tbody>
                    </table>
                    <!-- End Invoice List Table -->
                </div>
            </div>
        </div>

    </div>
</div>
