<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;
    protected $fillable = [
        'name',
    ];
    public function products()
    {
        return $this->hasMany(Product::class);
    }
    public function company()
    {
        return $this->belongsTo(Company::class);
    }
    public function socialMedia()
    {
        return $this->hasMany(SocialMedia::class,'cat_id');
    }
}
